<?php get_header(); ?>

	<div id="content">

	<?php if (have_posts()) : ?>

	<?php /* If this is a category archive */ if (is_category()) { ?>
		<p><?php printf(__('Archive(s) for the &#8216;%s&#8217; Category', 'albator'), single_cat_title('', false)); ?></p>

 		<?php /* If this is a tag archive */ } elseif ( function_exists ('is_tag') && (is_tag()) ) { ?>
		<p><?php printf(__('Posts Tagged &#8216;%s&#8217;', 'albator'), single_tag_title('', false) ); ?></p>

	 <?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<p><?php printf(_c('Archive(s) for %s|Daily archive page', 'albator'), get_the_time(__('F jS, Y', 'albator'))); ?></p>

	 <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<p><?php printf(_c('Archive(s) for %s|Monthly archive page', 'albator'), get_the_time(__('F, Y', 'albator'))); ?></p>

		<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<p><?php printf(_c('Archive(s) for %s|Yearly archive page', 'albator'), get_the_time(__('Y', 'albator'))); ?></p>

	  <?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<p><?php _e('Author archive', 'albator'); ?></p>

		<?php } ?>
		
		<div class="navigation">
			<div class="alignleft"><?php next_posts_link(__('&laquo; Older Entries', 'albator')); ?></div>
			<div class="alignright"><?php previous_posts_link(__('Newer Entries &raquo;', 'albator')); ?></div>
		</div>

		<?php while (have_posts()) : the_post(); ?>
				
			<div class="post" id="post-<?php the_ID(); ?>">
				<h2 class="posttitle"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php printf(__('Permanent Link to %s', 'albator'), the_title_attribute('echo=0')); ?>"><?php the_title(); ?></a></h2>
				<div class="postmetadata"><?php the_time(__('l, F jS, Y', 'albator')) ?> <!-- <?php _e('by') ?> <?php the_author() ?> --></div>
				<div class="postentry">
					<?php the_content("<small>".__('Continue reading...','albator')."</small>"); ?>
				</div>
		
				<div class="postmetadata">
					<?php if( function_exists('the_tags') ) 
						the_tags(__('Tags: ','albator'), ', ', '<br />'); 
					?>
					<?php _e('Category:','albator') ?> <?php the_category(', ') ?>&nbsp;&nbsp;|&nbsp;
					<?php comments_popup_link(__('Comment','albator'), __('1 Comment','albator'), __('% Comments','albator')); ?>
					<?php edit_post_link(__('Edit','albator'), '&nbsp;|&nbsp;&nbsp;', ''); ?>
				 </div>
			</div>
	
		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link(__('&laquo; Previous Entries', 'albator')); ?></div>
			<div class="alignright"><?php previous_posts_link(__('Next Entries &raquo;', 'albator')); ?></div>
		</div>
		
	<?php else : ?>
		<div class="post">
			<h2 class="posttitle"><?php _e('Not Found','albator') ?></h2>
			<div class="postentry"><p><?php _e('Sorry, no posts matched your criteria.','albator'); ?></p></div>
		</div>

	<?php endif; ?>

	</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
